/**************************************************************************************

Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.

***************************************************************************************

  $Id: AP_Phy.h 4490 2020-08-13 13:32:21Z Robert $:

  Description:
    USER - Headerfile of PHY Module

  Changes:
    Date        Description
    -----------------------------------------------------------------------------------
    2010-03-23  File created.

**************************************************************************************/


#ifndef __AP_PHY_H
#define __AP_PHY_H

#ifdef __cplusplus
extern "C" {
#endif

  /*
  ******************************************************************************
  *   Size of one PHY Control Block a Task has to allocate memory for
  ******************************************************************************
  */ 
  
  #define DRV_PHY_SIZE (316)

  /*
  ************************************************************
  *   Function Prototypes
  ************************************************************
  */
  RX_FATAL FAR    DrvPhyInit              (const FAR void FAR*      pvCfg,
                                           UINT                     uNum);


  RX_RESULT FAR   Drv_PhyCreatePhy        (RX_HANDLE                hPhy,
                                           const RX_PHY_SET_T FAR*  ptCfg);

  RX_RESULT FAR   Drv_PhyIdentifyPhy      (const STRING FAR*        pszIdn,
                                           UINT                     uInst,
                                           RX_HANDLE FAR*           phPhy);

  RX_RESULT FAR   Drv_PhyTestLoopback     (RX_HANDLE                hPhy);

  RX_RESULT FAR   Drv_PhyInitialize       (RX_HANDLE                hPhy);

  RX_RESULT FAR   Drv_PhyReadRegister     (RX_HANDLE                hPhy,
                                           UINT                     uRegAddr,
                                           UINT FAR*                puData);

  RX_RESULT FAR   Drv_PhyWriteRegister    (RX_HANDLE                hPhy,
                                           UINT                     uRegAddr,
                                           UINT                     uData);

#ifdef __cplusplus
}
#endif

#endif
